/* exported mc_get_ip_list */
/* exported mc_get_port */


/* global mc_sdk_param */
/* global $ */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取ip地址列表
 * 参数:
 *    @param {Promise<Function>}  fun_callback  回调函数
 * 返回：
 *  NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_ip_list(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("", "");
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("CLOUD_LOCAL_IP");
    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("", "");
            return;
        }
        var arr_val = [];
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");
        var err_cnt = obj_res.get_param_cnt();

        for (var idx = 0; idx < err_cnt; idx++) {
            var err_val = obj_res.get_param_name(idx);

            if ("ERROR_CODE" !== err_val) {
                var err_param = obj_res.get_param_value(err_val);

                arr_val.push(err_param);
            }
        }


        fun_callback(arr_val, str_error_date);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取端口号
 * 参数:
 *    @param {Promise<Function>}   回调函数

 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2020.9.14
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_get_port(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("", "");
        return;
    }

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("CLOUD_WEBSERVER_PORT");
    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("", "");
            return;
        }
        var arr_val = [];
        var obj_res = new mc_sdk_param();

        obj_res.set_json(result);
        var str_error_date = obj_res.get_param_value("ERROR_CODE");
        var err_cnt = obj_res.get_param_cnt();

        for (var idx = 0; idx < err_cnt; idx++) {
            var err_val = obj_res.get_param_name(idx);

            if ("ERROR_CODE" !== err_val) {
                var err_param = obj_res.get_param_value(err_val);

                arr_val.push(err_param);
            }
        }


        fun_callback(arr_val, str_error_date);
    });
}
